/* Quadratwurzel ohne Errorausgabe fuer negative Radikanden       */

#define  abs(A) ( (A) < 0 ? -(A) : (A) )   /* "Funktion" per define */
#define  DELTA  1.0e-16

main() {
     int i;
     double wurzel();
     for (i=0; i < 10; i++)
         printf( "%d  %20.16f\n", i, wurzel( (double)i ) );
}

double wurzel(double n) {
    double  x = n, alt_x = 0;
    if (n <= 0) 
	  return 0;

    while ( abs(x - alt_x) > DELTA ) {
          alt_x = x;
          x = (n/x + x)/2;
    }
    return x;
}
