/* titel: ascii.c; gibt Ascii-Zeichen aus. Eingabe oktal, dezimal, hex */
/* ASCII = American Standard Code for International Interchange   */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
char *name[] = { "NUL","SOH","STX","ETX","EOT","ENQ","ACK","BEL",
		 "BS", "HT", "LF", "VT", "FF", "CR", "SO", "SI",
                 "DLE","DC1","DC2","DC3","DC4","NAK","SYN","ETB",
                 "CAN", "EM","SUB","ESC", "FS", "GS", "RS", "US",
                 "SP" };
char *eingabe = "\
  Eingabe eines Einzelzeichens liefert dessen Asciiwert \n\
  Eingabe von ^Zeichen liefert Asciiwert des Control-Zeichens\n\
  Eingabe einer mehrstelligen Ziffer liefert zugehoeriges Asciizeichen\n\
  Eingabe einer Ziffer mit vorangestelltem\n\
                o, O oder 0:      Ziffer wird oktal gelesen\n\
		d oder D:         Ziffer wird dezimal gelesen\n\
	        x oder X:	  Ziffer wird hexadezimal gelesen\n\
		tab oder TAB:	  Eine Ascii-Tabelle wird ausgegeben\n\
  		Abbruch mit Ctrl-C\n";
	        
main() {
  char s[10]; int c,d;
  printf( eingabe );
  while (1) {   
    printf(": "); scanf("%s",s);
    if ( strcmp(s, "tab") == 0 || strcmp(s, "TAB") == 0) {
      tabelle();
      continue;
    }
    if ( strlen(s) == 1 ) c = s[0];
    else if ( s[0] == '^' ) c = s[1] & 0x1f ;	
    else if ( s[0] == 'o' || s[0] == 'O' || s[0] == '0')
      sscanf(&s[1],"%o",&c);
    else if ( s[0] == 'd' || s[0] == 'D')
      sscanf(&s[1],"%d",&c);
    else if	( isdigit( s[0] ) )	
      sscanf(s, "%d", &c);		
    else if ( s[0] == 'x' || s[0] == 'X' )	
      sscanf(&s[1],"%x",&c);
    c &= 0xff;
    if ( !iscntrl(c) && c != ' ')        
      printf("ASCII(%c) = o%o  d%d  x%x\n", c,c,c,c);
    else if ( c == ' ' )
      printf("ASCII( ) = %s = o%o  d%d  x%x\n", name[c],c,c,c);
    else if ( c != 0x7f )
      printf("ASCII(^%c) = %s = o%o  d%d  x%x\n", c+0x40,name[c],c,c,c);
    else
      printf("ASCII(DEL) = o%o  d%d  x%x\n",c,c,c);
  }
}

tabelle() {
  int i;
  printf("\n");
  for (i=0; i < 31; i++)
    printf("\t%3d %2x %s\t%3d %2x %c\t%3d %2x %c\t%3d %2x %c\n",\
	   i,i,name[i],i+32,i+32,i+32,i+64,i+64,i+64,i+96,i+96,i+96);
  printf("\t%3d %2x %s\t%3d %2x %c\t%3d %2x %c\t%3d %2x DEL\n",\
	 i,i,name[i],i+32,i+32,i+32,i+64,i+64,i+64,i+96,i+96);
  printf("\n");
}
