/* titel: cat.c, concateniert Dateien, Ausgabe auf stdout */

#include <stdio.h>

char *prog;
main( int argc, char *argv[] ) {
  int i; FILE *quelle, *eopen(char *, char *);
  void filecopy(FILE *, FILE *);
  prog = argv[0];

  if (argc == 1)
    filecopy(stdin, stdout);
  else
    for(i = 1; i < argc; i++) {
      quelle = eopen(argv[i], "r");
      filecopy(quelle, stdout);
      fclose(quelle);
    }
  exit(0);
}

void filecopy(FILE *q, FILE *z) {
  int c;
  while ((c = getc(q)) != EOF)
    putc(c,z);
}

FILE *eopen(char *name, char *mode) {
  FILE *fp;
  if ( (fp = fopen(name,mode)) == NULL) {
    fprintf(stderr,\
     "eopen in %s: File %s can't be opened in mode %s.\n", prog, name, mode);
    exit(1);
  }
  return fp;
}
