/* titel: isqrt.c, ganzzahlige Wurzelfunktionen */
#include <time.h> 
/* typedef int time_t;  Ersatz, falls time.h nicht vorhanden */

/* Vier Forward-Deklarationen von Funktionen:    */

int isqrt(); int isqrt_0(); int isqrt_1(); int isqrt_2(); int isqrt_3();
                      
/* Eintrag dieser Funktionennamen in ein Array: */
        
int (*fct[])() = { isqrt, isqrt_0, isqrt_1, isqrt_2, isqrt_3 , NULL}; 

/* Das folgende Programm misst die Laufzeiten dieser Funktionen: */

main() {       
    int root, i, iter = 1; long n; time_t tta, tte;
    int (**f)();
    while( iter ) { 
	printf("\nIterationenzahl (Abbruch mit 0): " ); scanf("%d",&iter);
        if ( iter == 0) break;
        printf("Wurzel aus: "); scanf("%ld",&n);
        for( f = fct; *f; f++) {
	    time( &tta );
            for ( i = 0; i < iter; i++) 
		root = (**f)(n);
            time( &tte );
            printf("result = %u, Zeit: %ld sec.\n",root,tte-tta);
	}
    }
}
/* Die folgenden Funktionen bestimmen den ganzzahligen Anteil der 
   Quadratwurzel aus n. */

int isqrt(long n) {      /* Nur mit Bitshifts, Additionen und Subtraktionen */
    register int i;  register long root=0, left=0;
    for ( i = (sizeof(long)<<3) - 2; i >= 0; i -= 2 ) {
	left = left<<2 | n>>i & 3 ;
        root <<= 1;
        if ( left > root )  
	    left -= ++root, ++root;
    }
    return (int)(root>>1) ;
}

int isqrt_0(long n) {    /* Variation von isqrt */
    register unsigned long m, root = 0, left = n;
    for ( m=(long)1; m < n>>2; m <<= 2) ;
    for ( ; m; m >>= 2 ) {
	if ( ( left & -m ) > root ) 
	    left -= ( root += m ), root += m;
	root >>= 1; 
    }
    return (int)root;
}

int isqrt_1(long n) {    /* Variation von isqrt */
    register unsigned long m, root = 0, left = n;
    for ( m = (long)1<<( (sizeof(long)<<3) - 2); m; m >>= 2 ) {
	if ( ( left & -m ) > root ) 
	    left -= ( root += m ), root += m;
	root >>= 1; 
    }
    return (int)root;
}

int isqrt_2(long n) {    /* Ganzzahlige Variante von Newtons Methode */
    register unsigned int a = 0xffffffff, b = a-1;
    while ( b < a ) {
	a = b;
        b = a+n/a >> 1;
    }
    return a;
}

#include <math.h>  /* Zum Vergleich: Mit der Fliesskomma-Bibliothek */
int isqrt_3(long n)  {
    return (int)sqrt( (double)n );
}
