/* titel: baum.c; Binaerbaum als Beispiel zur dynamischen Speicherverwaltung */


#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include <stdlib.h>

#define MAX_WORT      40
char *progname;
struct  node {
            char *wort;
            int  zahl;
            struct node *links;
            struct node *rechts;
};

typedef struct node knoten;

FILE *quelle, *ziel;
/*  main  liest aus der Quellatei die Woerter und gibt sie
**        lexikographisch sortiert mit Haeufigkeitsangabe 
**        in die Zieldatei aus.
*/
main(int argc, char *argv[]) {   
    knoten *unterbaum, *suche();
    char   wort [ MAX_WORT ] ;
    int    c;
    FILE   *eopen();
    progname =  argv[0];
    if ( argc != 3 ) {
        fprintf(stderr,"Syntax: %s Quelldatei Zieldatei\n",progname);
        exit(1);
    }
    quelle = eopen(argv[1],"r");       
    unterbaum = NULL;
    while ( ( c = lieswort( wort, MAX_WORT) ) != EOF )
      if (c == 'a')
	unterbaum = suche( unterbaum, wort );
    fclose(quelle);
    ziel = eopen(argv[2],"w");
    inorder( unterbaum );
    fclose(ziel);
}

/*  lieswort  liest aus einer Datei ein Wort der Laenge < lim in den
**            Speicher, auf den w zeigt, und gibt 'a' zurueck, falls es
**            wirklich Alphazeichen gelesen hat, jedoch EOF im Fall zu
**            grosser Wortlaenge. Falls Nicht-Alpha-Zeichen gelesen werden,
**            werden diese einzeln zurueckgegeben.
*/
lieswort(char *w, int lim) {   
    int c;
    
    while ( !isalpha( c = getc(quelle) ) ) 
      if ( c == EOF ) 
	return c;
    *w++ = c; 
    lim--;    
    
    while ( isalpha( c = getc(quelle) )  && lim > 0 ) {    
      *w++ = c; lim--;   
    }
    if   (lim == 0) {     
      printf("%s: Error: Wort zu lang ", progname); 
      return EOF; 
    }
    else 
      *w = 0;
    if (lim < MAX_WORT) 
      return 'a'; 
    else  
      return c;
}
FILE *eopen(char *file,char *mode) {   
    FILE *fp, *fopen();

    if ( (fp = fopen(file, mode)) != NULL )
         return fp;
    fprintf(stderr, "\
         %s: Datei %s kann im Modus %s nicht geoeffnet werden\n",\
         progname, file, mode );
    exit(1);
}

/*   suche  durchsucht den Baum auf das Vorkommen des Wortes w,
**   traegt es gegebenenfalls lexikographisch richtig ein bzw. erhoeht
**   dessen Zahl und gibt den Pointer auf seinen Knoten zurueck.
**   Die c-Funktion strcmp vergleicht zwei Zeichenketten lexikographisch
**   mit Rueckgabe einer negativen Zahl, 0 oder einer positiven Zahl.
*/
knoten *suche(knoten *p, char *w) {    
     knoten *p_knoten();
     char *merke_wort();
     int  cond;
     if   (p == NULL) {
          p = p_knoten();
          p->wort = merke_wort(w);
          p->zahl = 1;
          p->links = p->rechts = NULL;
     }
     else if   ((cond = strcmp(w, p->wort)) == 0)
               p->zahl++;
          else if   (cond < 0)
                    p->links = suche(p->links, w);
               else p->rechts = suche(p->rechts, w);
     return p ;
}
/*   p_knoten  gibt einen Zeiger auf freien Speicherplatz fuer
**             eine Knoten-Variable zurueck.
*/
knoten *p_knoten(void) {    
     return (knoten *)malloc( sizeof( knoten ) ) ;
}
/*   inorder  gibt den Unterbaum, auf den p zeigt, in Inorder aus.
**            (rekursive Version!)
*/
inorder(knoten *p) {    
     if (p != NULL){  
       inorder(p->links);
       fprintf( ziel, "%4d %s\n", p->zahl, p->wort);
       inorder(p->rechts);
     }
}
/*  merke_wort  speichert das Wort, auf dessen ersten Charakter s zeigt,
**              und gibt einen Zeiger auf dessen neue Lokation an.
**              die c-Funktionen strlen, strcpy geben die Laenge einer
**              Zeichenkette zurueck beziehungsweise kopieren diese.
*/
char *merke_wort(char *s) {   
    char *p;
    if ( ( p = (char *)malloc( strlen(s)+1 ) ) != NULL )
       strcpy(p, s);
    return p ;
}
