
/* Titel: longest.c, gibt laengste Zeile eines Textes aus */

#include <stdio.h>
#define MAXLINE  1000             /* K.-R.  p. 29  */
int getline(char line[], int maxline);
void copy(char to[], char from[]);

main() {
      int len;
      int max;
      char line[MAXLINE];       /* aktuelle Eingabezeile            */
      char longest[MAXLINE];    /* laengste bisher gelesene Zeile   */
      max = 0;
      while ( (len = getline(line, MAXLINE)) > 0)
            if (len > max) {
                max = len;
                copy(longest, line);
            }
      if (max > 0)
            printf("%s", longest);
      return 0;
}

/* getline liest eine Zeile nach s[] und gibt deren Laenge zurueck */

int getline(char s[], int lim) {
      int c, i;
      for ( i=0; i < lim-1 && (c=getchar()) != EOF && c != '\n'; ++i)
             s[i] = c;
      if (c == '\n') {
            s[i] = c;
            ++i;
      }
      s[i] = '\0';
      return i;
}

/* copy kopiert "from" nach "to" ohne Ueberpruefen der Groesse von "to" */

void copy(char to[], char from[]) {
      int i = 0;
      while ( (to[i] = from[i]) != '\0')
           ++i;
}
