#include <stdio.h>

struct complex { 
  double r; 
  double i; 
};

typedef struct complex cpx;

cpx makecpx(double, double);
cpx sum(cpx, cpx);
cpx product(cpx, cpx);
cpx power(cpx, int);
void compprint(cpx);

main() {            /* Berechnet Potenzen komplexer Zahlen */
    int k;
    cpx basis, result;
    basis = makecpx(1,1);
    for (k=0; k < 10; ++k) {
      result = power( basis, k );
      printf("%2d   ", k ); 
      compprint(result);
    }
}

cpx makecpx(double r, double i) {
  cpx tmp;
  tmp.r = r; tmp.i = i;
  return tmp;
}

cpx sum(cpx a, cpx b) {
  a.r += b.r;
  a.i += b.i;
  return a;
}

cpx power( cpx basis, int expo) {
  cpx u = { 1, 0};
  while (expo > 0) {
    if (expo % 2) {
       expo--; 
       u = product(basis, u);
    }
    else {
       expo /= 2; 
       basis = product(basis, basis);
    }
  }
  return u;
}

cpx product(cpx x, cpx y) {
  cpx u;
  u.r = x.r * y.r - x.i * y.i;
  u.i = x.r * y.i + x.i * y.r;
  return u;
}

void compprint(cpx z) {  /* Druckt eine komplexe Zahl  */ 
   if (z.r != 0 && z.i != 0)
        printf("%5.2f + %5.2f * i\n", z.r, z.i);
   else if (z.r == 0 && z.i != 0)
        printf("%13.2f * i\n", z.i);
   else if (z.r != 0 && z.i == 0)
        printf("%5.2f\n", z.r);
   else printf("0\n");
}







